; ROM module vectors 

include "module.inc"            ; include definitions

include "..\..\..\..\10 - Spectranet\spectranet\trunk\include\zxrom.inc"
include "..\..\..\..\10 - Spectranet\spectranet\trunk\include\spectranet.inc"
include "..\..\..\..\10 - Spectranet\spectranet\trunk\modules\basext\defs.inc"
include "..\..\..\..\10 - Spectranet\spectranet\trunk\include\sysvars.inc"
include "..\..\..\..\10 - Spectranet\spectranet\trunk\include\sysdefs.inc"


.section vectors
	defb 0xAA                   ; Executable code module
	defb module_id              ; ROM ID number
	defw F_installcmd           ; RESET vector
	defw 0xFFFF                 ; FS MOUNT vector
	defw 0xFFFF                 ; Reserved
	defw 0xFFFF                 ; Reserved
	defw 0xFFFF                 ; Post BASIC init vector
	defw 0xFFFF                 ; Reserved
	defw STR_ident              ; Module identity string from ver.asm
	jr F_modulecall             ; Modulecall vector
	;FS vector table is located here for a FS module

F_modulecall:
	ret                         ; no modulecall functions

;----------------------------------------------------------------------------
; This module doesn't really need a MODULECALL function, but this
; is provided to demonstrate the use of MODULECALL.
F_main:
        ld a, l                 ; save parameter that's passed in L
        push af
        ld hl, STR_main         ; show a string
        call PRINT42
        pop af
        ld hl, v_workspace
        call ITOH8              ; Convert the value that was passed in L
        ld hl, v_workspace      ; to a string and display it.
        call PRINT42
        ld a, 10;'\n'			; '\n'
        call PUTCHAR42
        ret                     ; Done.

;----------------------------------------------------------------------------
; This routine gets called on power up or reset. In this instance, we can
; use this routine to register a new BASIC command, *open.
F_installcmd:
        ld hl, PARSETABLE       ; Address of the command's information
        call ADDBASICEXT        ; register the new command.
        ret nc                  ; and if no error, we're finished.
.error:
        ld hl, STR_error
        call PRINT42
        ret

        ; The following is the data structure that is used by the Spectranet
        ; additional command parser. It's important to note that the
        ; structure itself is copied into the Spectranet's system variables,
        ; but the string is not! So don't overwrite the memory used by the
        ; string.
PARSETABLE:
        defb 0x0B               ; C Nonsense in BASIC
        defw CMDSTRING          ; Pointer to string (null terminated)
        defb 0xFF               ; This is filled with our page
        defw RUNCMD             ; Address of routine to call
CMDSTRING:
        defb "*open",0

;----------------------------------------------------------------------------
; This routine is invoked when *open is encountered by BASIC.
RUNCMD:
	; This code is run twice - once at syntax time to check syntax,
	; and once at runtime. The statement end call will handle returning
	; to the ZX ROM at syntax time, but will return as normal during
	; runtime.
	
	rst CALLBAS
	defw ZX_EXPT_EXP		; string parameter - a filename
	call STATEMENT_END      ; No more parameters so check for statement end.

	; This code does not get called at syntax time, because the
	; 'call STATEMENT_END' doesn't return conventionally at syntax time
	; as noted above.
	
	;rst CALLBAS				; call ROM CLS
	;defw CLS				;
	call CLEAR42			; Clear the screen
	
	rst CALLBAS				; fetch the
	defw ZX_STK_FETCH		; filename string
	ld hl, INTERPWKSPC+10	;
	call F_basstrcpy		; copy string from BASIC
	
	ld hl, INTERPWKSPC+10	; point HL at filename to open
	ld d, 0					; no flags
	ld e, O_RDONLY			; and read only
	call OPEN				;
	jp c, errorLoad			;

	push af					; save the filehandle
	ld de, BUFFER			; point DE at the text buffer
	ld bc, SCREENSIZE		; and length (how bytes of the screen to fill)
	call READ				;
	
	ld BC, 0x0000			; set print coordinates
	call F_printat			; to (0,0)
	ld hl, BUFFER			; and display the "buffer"
	call PRINT42			;
	
	call promptUser			; "Press any key" to continue
	
	;******************************
	
	call scrollOneLine	
	;call readNextLine
	;call promptUser
	
	;call scrollOneLine	
	;call readNextLine
	;call promptUser
	
	;call scrollOneLine	
	;call readNextLine
	
	;******************************
	
	pop af					; restore the file handle
	call VCLOSE
	jp exitload
errorLoad:
	ld hl, STR_openError
	call PRINT42
exitload:
	jp EXIT_SUCCESS         ; and pass control back to ZX ROM

	