include "module.inc"            ; include definitions

include "..\..\..\..\10 - Spectranet\spectranet\trunk\include\zxrom.inc"
include "..\..\..\..\10 - Spectranet\spectranet\trunk\include\spectranet.inc"
;include "..\..\..\..\10 - Spectranet\spectranet\trunk\modules\basext\defs.inc"
include "..\..\..\..\10 - Spectranet\spectranet\trunk\modules\snapman\snapman.inc"
include "..\..\..\..\10 - Spectranet\spectranet\trunk\include\sysvars.inc"
include "..\..\..\..\10 - Spectranet\spectranet\trunk\include\sysdefs.inc"

INTERPWKSPC		equ 0x3003	; workspace

.globl readNextLine
readNextLine:
	pop af
	push af
	ld de, LINE_BUFFER		; point DE at the text buffer
	ld bc, LINESIZE			; and length (how bytes of the screen to fill)
	call READ				;
	ld BC, 0x1500			; 
	call F_printat			;
	ld HL, LINE_BUFFER		;
	call PRINT42			;
	ret
	
.globl promptUser
promptUser:
	ld BC, 0x1600			; Display "Press any key" to continue
	call F_printat			; B=row, C=column
	ld hl, STR_pressAnyKey	;
	call PRINT42			;
	call F_getkey			; wait for a key to be pressed
	ret
	
.globl scrollOneLine
scrollOneLine:
	ld BC, 0x0100			; one line to scroll
	ld HL, 16384			; first line to scroll
	call F_scrollforward
	ret



;********* I lifted these from "command.asm" *******************************
;---------------------------------------------------------------------------
; F_get_stringarg: gets a single string arg, returning a pointer to the
; null-terminated string in HL
F_get_stringarg:
	rst CALLBAS
	defw ZX_STK_FETCH
	ld hl, INTERPWKSPC
	call F_basstrcpy
	ld hl, INTERPWKSPC
	ret
	
.globl F_basstrcpy
F_basstrcpy:
	ld a, b				; end of string?
	or c
	jr z, .terminate2
	ld a, (de)
	ld (hl), a
	inc hl
	inc de
	dec bc
	jr F_basstrcpy
.terminate2:
	xor a				; put the null on the end
	ld (hl), a
	inc hl
	ret	
;********* I lifted ^^^these^^^ from "command.asm" *******************************	



;********* I lifted these from "screen.asm" *******************************
;-------------------------------------------------------------------------
; F_printat: Move PRINT42 location.
; B = row
; C = column
.globl F_printat
F_printat: 
	ld a, b	
	and 0x18		; find the third of the screen
	add a, 0x40		; add MSB of the screen address
	ld h, a
	ld a, b
	and 0x07		; find where we are within that 1/3rd
	rlca			; multiply by 32
	rlca
	rlca
	rlca
	rlca
	ld l, a			; MSB of framebuffer address
	ld (v_row), hl		; set row address
	ld a, c
	ld (v_column), a	; set column address
	ret

	
;------------------------------------------------------------------------
; F_scrollarea
; Scroll an area of the screen.
; HL = pointer to first line to scroll
; B = number of lines to scroll
; C = 0 = scroll normal way, nonzero scroll reverse
.globl F_scrollforward
F_scrollforward: 
	push bc			; save counter
	call  .advance5		; advance one line (need to scroll
	push hl			; box size minus 1)
	jr z,  .moveloopthird5
.moveloop5: 
	push bc			; save line counter
	ld a, l
	sub 32			; address of next line up
	ld d, h			 
	ld e, a 
	push hl
	ld bc, (v_movebytes)
	ldir
	pop hl
	inc h
	pop bc
	djnz  .moveloop5
.nextline5: 
	pop hl
	pop af			; get counter
	dec a
	ret z			; all lines scrolled

	push af			; save counter
	call  .advance5
	push hl
	jr nz,  .moveloop5

.moveloopthird5: 
	push bc
	ld a, l
	or 0xE0			; set top 3 bits of LSB
	ld e, a
	ld a, h
	sub 0x08		; subtract 8 from MSB
	ld d, a			; DE now equals address of prev row
	push hl
	ld bc, (v_movebytes)
	ldir
	pop hl
	inc h
	pop bc
	djnz  .moveloopthird5
	jr  .nextline5

.advance5: 
        ld a, l
        and 0xE0
        cp 0xE0                 ; about to go into the next third?
        jr z,  .nnextthird5
        ld a, 32
        add a, l                ; next line
        ld l, a
        ld b, 8                 ; number of iterations per line
	ret
.nnextthird5: 
        ld a, l
        and 0x1F                ; clear 3 most significant bits
        ld l, a                 ; set LSB of pointer
        ld a, h
        add a, 8
        ld h, a                 ; set MSB of pointer
        ld b, 8                 ; move 8 lines
	xor a
	ret
;------------------------------------------------------------------------
;********* I lifted ^^^these^^^ from "screen.asm" *******************************	

;********* I lifted these from "ui_input.asm" *******************************
;===========================================================================
; F_getkey:
; Waits for a key to be pressed, and returns the key in A.
; The routine returns the key on keydown. The calling routine should then
; wait for keyup before getting the next key.
.globl F_getkey
F_getkey:
	ld a, DATAROM		; key scan routines live here
	call F_pushpageA
.loop1:
	call F_key_scan
	call F_key_test
	jr nc, .loop1
	ld e, a			; partially decoded key is in A, copy it to E
	ld d, 8			; not in 'K' cursor mode
	ld c, 0			; FLAGS = 0
	call F_key_code		; decode keypress into actual ascii value
	ld c, a
	call F_poppageA		; restore original page A
	ld a, c
	ret
;===========================================================================
;********* I lifted ^^^these^^^ from "ui_input.asm" *******************************	

;********* I lifted these from "pager.asm" *******************************
F_setpageA: 
	push bc
	ld bc, PAGEA
	ld (v_pga), a	; save the page we've just paged.
	out (c), a	; page it in
	pop bc
	ret
	
; Set paging area A and push the page currently selected onto the stack.
; A = new page to select
.globl F_pushpageA
F_pushpageA: 
	ld (v_pagerws), hl
	ld hl, (v_pga)		; get current page (and the adjacent byte)
	ex (sp), hl		; stack it
	push hl			; put the return address back
	call F_setpageA		; set the new page
	ld hl, (v_pagerws)	; restore hl
	ret

; Restore page area A from the stack
.globl F_poppageA
F_poppageA: 
	ld (v_pagerws), hl
	pop hl			; get the return address
	ex (sp), hl		; get the page to restore
	ld a, l			; the page itself being in L
	call F_setpageA		; restore the page
	ld hl, (v_pagerws)
	ret
;********* I lifted ^^^these^^^ from "pager.asm" *******************************	





;**********************************************************************************************

;The MIT License
;
;Copyright (c) 2008 Matt Westcott
;
;Permission is hereby granted, free of charge, to any person obtaining a copy
;of this software and associated documentation files (the "Software"), to deal
;in the Software without restriction, including without limitation the rights
;to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
;copies of the Software, and to permit persons to whom the Software is
;furnished to do so, subject to the following conditions:
;
;The above copyright notice and this permission notice shall be included in
;all copies or substantial portions of the Software.
;
;THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
;AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
;LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
;OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
;THE SOFTWARE.
;
; This file is a slightly modified version of the ZX key scanning routines
; from Matt Westcott's (gasman) Open ZX ROM.
.data
flags2:			equ 23658
key_table:
			; mapping from key codes (as returned in E by key_scan) to 'base characters'
			db "BHY65TGVNJU74RFC"
			db "MKI83EDX", 0x0e, "LO92WSZ"
			db " ", 0x0d, "P01QA"
			
;			block 0x8060-$,0
			; table of control codes produced by keys 0-9 in conjunction with caps shift
key_table_caps_digits:
			db 0x0c,0x07,0x06,0x04,0x05,0x08,0x0a,0x0b,0x09,0x0f
; 0x026a
			; table of symbols / tokens produced by keys A-Z in conjunction with symbol shift
key_table_sym_letters:
			db 0xe2, '*', '?', 0xcd, 0xc8, 0xcc, 0xcb, '^'
			db 0xac, '-', '+', '=', '.', ',', ';', '"'
			db 0xc7, '<', 0xc3, '>', 0xc5, '/', 0xc9, 0x60, 0xc6, ':'
.text
.globl F_key_scan
F_key_scan:
			; scan keyboard, returning key code(s) in DE.
			; Numbering rows B-Sp=0, H-En=1, Y-P=2, 6-0=3, 1-5=4, Q-T=5, A-G=6, Cs-V=7,
			; key code is rownum + ((5 - bit number) << 3).
			; The first key encountered, ordering by descending row and ascending bit
			; within row, is put in E. The second key is put in D.
			; If one of the keys is caps shift, this will be placed in D.
			; Otherwise, if one of the keys is symbol shift, this will be placed in D.
			; The zero flag is returned reset if >2 keys are pressed, or 2 keys are pressed
			; and neither is a shift.
			ld de,0xffff
			ld b,7							; scan each of 8 rows
			ld a,0xfe						; with each bit in turn held low
key_scan_row:
			push af
			in a,(0xfe)
			ld c,a							; pick apart result of IN in register C
			ld a,0x20						; count down bit number in A, premultiplied by 8
key_scan_bit:
			push af
			rr c
			jr c,key_scan_bit_done			; if bit is nonzero (-> carry set), key not pressed; move on
			add a,b							; assemble key code from bit number and row number
			inc e							; check if e register is vacant
			jr nz,key_scan_e_not_vacant
			ld e,a
			jr key_scan_bit_done
key_scan_e_not_vacant:
			dec e							; e is already occupied; restore value
			inc d							; check if d register is vacant
			jr z,key_scan_d_vacant
			pop hl							; if not, there are too many keys;
			pop hl							; restore stack and exit with Z reset
			ret
key_scan_d_vacant:
			ld d,a
key_scan_bit_done:
			pop af
			sub 8							; if counter in A does not roll over,
			jr nc,key_scan_bit				; there are bits remaining to check
			pop af							; go to next row once we've checked 5 bits
			dec b
			rlca							; keep scanning rows for as long as the zero bit
			jr c,key_scan_row				; doesn't fall off the end of A
			; keys collected; now handle shifts
			ld a,d
			inc a							; see if d is still 0xff (i.e0. only one key)
			ret z							; if so, exit with Z set
			ld a,e
			cp 0x27							; check E for caps shift
											; (it's the first key we check, so it'll always
											; be in E if at all)
			jr nz,key_scan_no_cs
			ld e,d							; if E is caps shift, switch D and E
			ld d,a							; and exit with Z set
			ret
key_scan_no_cs:
			cp 0x18							; check E for symbol shift
			jr nz,key_scan_no_ss
			ld e,d							; if E is sym shift, switch D and E
			ld d,a							; and exit with Z set
			ret
key_scan_no_ss:
			ld a,d							; only remaining valid condition is if D is
			cp 0x18							; symbol shift; check for this condition and
			ret								; return with Z flag indicating the result

.globl F_key_test
F_key_test:
			; Test that a successful (zero flag set) response from key_scan is indeed
			; a real key (i.e0. not just a shift key on its own). As described by Toni Baker
			; (Mastering Machine Code on your ZX Spectrum, ch11):
			;   i) B will be made to contain the value formerly held by D
			;  ii) D will be made to contain zero
			; iii) if DE started off as FFFF, FF27 or FF18, return with low byte in A and carry reset
			;  iv) otherwise, translate the key code into its base character (capitalised ASCII code)
			;      and return that in A, with carry set
			ld b,d
			ld d,0
			ld a,b				; is high byte 0xff?
			inc a
			ld a,e				; load A with low byte either way
			jr nz,key_test_not_ff	; if not, key scan result is ok
			cp 0x27				; is low byte >= 0x27 (which can only be 0x27 or 0xff)?
			ret nc				; return with carry reset if so
			cp 0x18				; is low byte 0x18?
			ret z					; return with carry reset if so
key_test_not_ff:
			ld hl,key_table
			add hl,de
			ld a,(hl)
			scf
			ret
; 0x0333
.globl F_key_code
F_key_code:
			; Convert base character to ASCII code, respecting shifts and current key mode.
			; entry: E = base character
			; B = shift code (FF, 27 or 18)
			; C = editor mode (0 = K/L/C, 1 = E, 2 = G)
			; bit 3 of D = 0 for K mode, 1 for L/C mode
			; bit 3 of FLAGS2 = 0 for L mode, 1 for C mode
			; return: A = ASCII code
			; NB: for now, we'll only consider C and L modes because the others aren't much use
			; until we have a Basic editor.
			ld a,b
			cp 0x18				; test shift code for symbol shift
			jr z,key_code_sshift	; jump ahead if symbol shift active
			cp 0x27				; test shift code for caps shift
			jr z,key_code_cshift	; jump ahead if caps shift active
			ld a,(flags2)	; get caps lock state from flags2 system variable
			and 0x08			; - test bit 3
			ld a,e				; pick up base character code
			ret nz				; return it unchanged if caps lock is set
			cp 'A'				; also return character code unchanged if caps lock is off
			ret c					; but character is not a letter (= code < 'A')
			add a,0x20		; otherwise, translate to lower case by adding 0x20
			ret
			
key_code_sshift:
			ld a,e
			cp '0'
			ret c					; return keycode unchanged if <'0' (= space or enter)
			cp 'A'				; if it's a letter (code >= 'A'), jump ahead and look up in table
			jr nc,key_code_sshift_letter
			; otherwise, deal with numbers
			cp '0'				; 0 and 2 are special cases.
			jr z,key_code_underline	; These take so many bytes to handle that we would have been
			cp '2'				; far better off with a 10-byte lookup table. But no, we had
			jr z,key_code_at				; to make it overly complicated...
			sub 0x10			; for all others, just subtract 0x10 to get the resulting ASCII symbol
			ret
key_code_underline:
			ld a,'_'
			ret
key_code_at:
			ld a,'@'
			ret
			
key_code_sshift_letter:
			ld d,0				; look up letter in the table key_table_sym_letters
			ld hl,key_table_sym_letters - 'A' ; fiddle base address of table to count from ASCII 'A'
			add hl,de
			ld a,(hl)
			ret
			
key_code_cshift:
			ld a,e
			cp '0'				; return keycode unchanged if <'0' (space, enter or symbol shift);
			ret c				; NB key code for symbol shift is 0x0E = extend mode, which is correct here
			cp 'A'				; also return keycode unchanged if it's a letter (code >= 'A')
			ret nc
			ld d,0				; otherwise, look it up in the table key_table_caps_digits
			ld hl,key_table_caps_digits - '0'	; fiddle base address of table to start counting from ASCII '0'
			add hl,de
			ld a,(hl)
			ret
			
