; --------------------------------------------------------------------------
;
; Code from Guesser to scroll the display
;
; --------------------------------------------------------------------------


; > HL = (0 UP / 1 DOWN)

.globl scroll_scr
scroll_scr:
	di						; disable interrupts
	push	af				; store registers
	push	bc				;
	push	de				;
	ld	(stack+1), sp		; store current stack pointer

	ld	sp, up_tab			; point stack pointer at up_tab
	bit	0, l				; Is HL 0 or 1
	jr	z, up				; scrolling up
	ld	sp, down_tab		; scrolling down
up:
	ld	b,20;19				; Height in characters

down:
	pop	de					; Source
	pop	hl					; Destination
	dec	sp
	dec	sp

	ld	c,244				; (30*8)+4

line:
	ldi						; Forwards copy - copies HL to DE (BC times)
	ldi						; increments HL and DE each time
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	
	ld	a, (hl)				; Last character
	ld	(de), a
	inc	h					; Down 1 line
	inc	d

	ldd						; Backwards copy - copies HL to DE
	ldd						; then decrements BC, DE and HL
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	
	ld	a, (hl)				; First character
	ld	(de), a
	inc	h					; Down 1 line
	inc	d

	dec	c
	jp	nz, line			; Next line

	dec	b
	jp	nz, down

	jr	stack


; --------------------------------------------------------------------------


up_tab:
	defw	16384+(32*0)	; MSS - Line 0
	defw	16384+(32*1)	; MSS - Line 1
	defw	16384+(32*2)	; Line 2
	defw	16384+(32*3)
	defw	16384+(32*4)
	defw	16384+(32*5)
	defw	16384+(32*6)
	defw	16384+(32*7)
	defw	18432+(32*0)
	defw	18432+(32*1)
	defw	18432+(32*2)
	defw	18432+(32*3)
	defw	18432+(32*4)
	defw	18432+(32*5)
	defw	18432+(32*6)
	defw	18432+(32*7)
	defw	20480+(32*0)
	defw	20480+(32*1)
	defw	20480+(32*2)
	defw	20480+(32*3)
	defw	20480+(32*4)
down_tab:
	defw	20480+(32*5)	; Line 21
	defw	20480+(32*4)
	defw	20480+(32*3)
	defw	20480+(32*2)
	defw	20480+(32*1)
	defw	20480+(32*0)
	defw	18432+(32*7)
	defw	18432+(32*6)
	defw	18432+(32*5)
	defw	18432+(32*4)
	defw	18432+(32*3)
	defw	18432+(32*2)
	defw	18432+(32*1)
	defw	18432+(32*0)
	defw	16384+(32*7)
	defw	16384+(32*6)
	defw	16384+(32*5)
	defw	16384+(32*4)
	defw	16384+(32*3)
	defw	16384+(32*2)	; Line 2
	defw	16384+(32*1)	; MSS - Line 1
	defw	16384+(32*0)	; MSS - Line 0

; --------------------------------------------------------------------------


stack:
	ld	sp, 0				; this value is overwritten at the start of the routine
	pop	de					; restore registers
	pop	bc					;
	pop	af					;
	ei						; enable interrupts

	ret						; return to caller
