.globl mss_scroll
mss_scroll:
	push AF
	push BC
	push DE
	
	; ************  Screen block 1  **************
	; Copy line 1 to line 0
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	
	ld HL, 16384+(32*1)		; point HL at line 1
	ld DE, 16384		; point HL at line 0	
	call copy_line
	
	; Copy line 2 to line 1
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 16384+(32*2)		; point HL at line 1
	ld DE, 16384+(32*1)		; point HL at line 0	
	call copy_line
	
	; Copy line 3 to line 2
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 16384+(32*3)		; point HL at line 1
	ld DE, 16384+(32*2)		; point HL at line 0	
	call copy_line
	
	; Copy line 4 to line 3
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 16384+(32*4)		; point HL at line 1
	ld DE, 16384+(32*3)		; point HL at line 0	
	call copy_line
	
	; Copy line 5 to line 4
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 16384+(32*5)		; point HL at line 1
	ld DE, 16384+(32*4)		; point HL at line 0	
	call copy_line
	
	; Copy line 6 to line 5
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 16384+(32*6)		; point HL at line 1
	ld DE, 16384+(32*5)		; point HL at line 0	
	call copy_line
	
	; Copy line 7 to line 6
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 16384+(32*7)		; point HL at line 1
	ld DE, 16384+(32*6)		; point HL at line 0	
	call copy_line	
	
	; ************  Screen block 2  **************
	; Copy first line from SECOND SCREEN BLOCK
	; to the end of the FIRST BLOCK
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	
	ld HL, 18432		; point HL at line 1
	ld DE, 16384+(32*7)		; point HL at line 0	
	call copy_line	
	
	; Copy line 8 to line 7
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 18432+(32*1)		; point HL at line 1
	ld DE, 18432+(32*0)		; point HL at line 0	
	call copy_line
	
	; Copy line 3 to line 8
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 18432+(32*2)		; point HL at line 1
	ld DE, 18432+(32*1)		; point HL at line 0	
	call copy_line
	
	; Copy line 4 to line 9
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 18432+(32*3)		; point HL at line 1
	ld DE, 18432+(32*2)		; point HL at line 0	
	call copy_line
	
	; Copy line 5 to line 10
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 18432+(32*4)		; point HL at line 1
	ld DE, 18432+(32*3)		; point HL at line 0	
	call copy_line
	
	; Copy line 6 to line 11
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 18432+(32*5)		; point HL at line 1
	ld DE, 18432+(32*4)		; point HL at line 0	
	call copy_line
	
	; Copy line 4 to line 9
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 18432+(32*6)		; point HL at line 1
	ld DE, 18432+(32*5)		; point HL at line 0	
	call copy_line
	
	; Copy line 5 to line 10
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 18432+(32*7)		; point HL at line 1
	ld DE, 18432+(32*6)		; point HL at line 0	
	call copy_line

	; ************  Screen block 3  **************
	; Copy first line from THIRD SCREEN BLOCK
	; to the end of the SECOND BLOCK
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	
	ld HL, 20480		; point HL at line 1
	ld DE, 18432+(32*7)		; point HL at line 0	
	call copy_line	

	
	
	; Copy line 1 to line 0
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	
	ld HL, 20480+(32*1)		; point HL at line 1
	ld DE, 20480		; point HL at line 0	
	call copy_line
	
	; Copy line 2 to line 1
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 20480+(32*2)		; point HL at line 1
	ld DE, 20480+(32*1)		; point HL at line 0	
	call copy_line
	
	; Copy line 3 to line 2
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 20480+(32*3)		; point HL at line 1
	ld DE, 20480+(32*2)		; point HL at line 0	
	call copy_line
	
	; Copy line 4 to line 3
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 20480+(32*4)		; point HL at line 1
	ld DE, 20480+(32*3)		; point HL at line 0	
	call copy_line
	
	; Copy line 5 to line 4
	ld B, 0			; height in characters
	ld C, 244;4			; (30*8)+4 ???????????
	ld HL, 20480+(32*5)		; point HL at line 1
	ld DE, 20480+(32*4)		; point HL at line 0	
	call copy_line
	
	; ; Copy line 6 to line 5
	; ld B, 0			; height in characters
	; ld C, 244;4			; (30*8)+4 ???????????
	; ld HL, 20480+(32*6)		; point HL at line 1
	; ld DE, 20480+(32*5)		; point HL at line 0	
	; call copy_line
	
	; ; Copy line 7 to line 6
	; ld B, 0			; height in characters
	; ld C, 244;4			; (30*8)+4 ???????????
	
	; ld HL, 20480+(32*7)		; point HL at line 1
	; ld DE, 20480+(32*6)		; point HL at line 0	
	; call copy_line
	
	
	
	pop DE
	pop BC
	pop AF
	ret
	
	
; copies the current character row	
copy_line:
	ldi					; Forwards copy - copies HL to DE (BC times)
	ldi					; increments HL and DE each time
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	;ldi	; MSS
	;ldi	; MSS
	
	ld	a, (hl)				; Last character
	ld	(de), a
	inc	h					; Down 1 line
	inc	d	
	
	ldd					; Backwards copy - copies HL to DE (BC times)
	ldd					; decrements HL and DE each time
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	;ldd	; MSS
	;ldd	; MSS
	
	ld	a, (hl)				; First character
	ld	(de), a
	inc	h					; Down 1 line
	inc	d

	dec	c
	jp	nz, copy_line			; Next line
	
	ret

	